var UR = UR || {};

UR.store = function() {
	var _remotes = JSON.parse(localStorage.remotes || JSON.stringify({Hash: 0}));
	var _layouts = JSON.parse(localStorage.layouts || JSON.stringify([]));

	function saveLayouts() {
		localStorage.layouts = JSON.stringify(_layouts);
	}

	return {
		saveRemotes : function(remotes) {
			var unsupported = [
				"Relmtech.Basic Input",
				"Unified.Command",
				"Unified.FileManager",
				"Unified.Start",
				"Unified.Screen",
				"Unified.ScrollWheel",
				"Unified.SendText",
				"Unified.TaskManager"
			];

			remotes.Remotes = _.filter(remotes.Remotes, function(r) {
				return _.indexOf(unsupported, r.ID) === -1;
			});

			_remotes = remotes;
			localStorage.remotes = JSON.stringify( remotes );
		},
		getRemotes : function() {
			return _remotes;
		},
		getRemoteHash : function () {
			return _remotes.Hash;
		},
		getRemoteList : function () {
			return _.sortBy(_remotes.Remotes, function (i) {
				i.Name.toLowerCase();
			});
		},
		getRemoteById : function (id) {
			return _.find(model.remotes, function(elm) {
				return elm.ID === id;
			});
		},
		updateLayouts : function(update, requestLayoutCallback) {
			_.forEach(update, function(layout_hash) {
				var id = layout_hash.ID;

				var idObj = {'ID': id};
				if (!_.some(_layouts, idObj)) {
					_layouts.push(idObj);
				}
				requestLayoutCallback(id, function(new_layout) {
					var index = _.findIndex(_layouts, idObj);
					var old_layout = _layouts[index];
					_layouts[index] = new_layout;
					saveLayouts();
				});
			});
		},
		getLayouts : function () {
			return _layouts;
		},
		getLayoutsHash : function () {
			return _.map(_layouts, function(obj) {
				return { 'ID': obj.ID, 'Hash': obj.Hash };
			});
		},
		getLayout : function(id) {
			return _.find(_layouts, {'ID': id});
		},
		getSavedCredentials: function () {
			if (localStorage.session) {
				return JSON.parse(UR.util.base64decode(localStorage.session));
			} else {
				return false;
			}
		},
		saveCredentials: function (auth) {
			localStorage.session = UR.util.base64encode(JSON.stringify(auth));
		},
		resetCredentials: function () {
			delete localStorage.session;
		}
	};
}();
